<?php
namespace wcf\data\user\option\category;
use wcf\data\DatabaseObject;
use wcf\system\WCF;

/**
 * Represents a user option category.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2017 WoltLab GmbH
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	WoltLabSuite\Core\Data\User\Option\Category
 *
 * @property-read	integer		$categoryID		unique id of the user option category
 * @property-read	integer		$packageID		id of the package which delivers the user option category
 * @property-read	string		$categoryName		name and textual identifier of the user option category
 * @property-read	string		$parentCategoryName	name of the user option category's parent category or empty if it has no parent category
 * @property-read	integer		$showOrder		position of the user option category in relation to its siblings
 * @property-read	string		$permissions		comma separated list of user group permissions of which the active user needs to have at least one to see the user option category
 * @property-read	string		$options		comma separated list of options of which at least one needs to be enabled for the user option category to be shown
 */
class UserOptionCategory extends DatabaseObject {
	/**
	 * Returns the title of this category.
	 * 
	 * @return	string
	 */
	public function __toString() {
		return $this->categoryName;
	}
	
	/**
	 * Returns an instance of UserOptionCategory by name.
	 * 
	 * @param	string		$categoryName
	 * @return	UserOptionCategory
	 */
	public static function getCategoryByName($categoryName) {
		$sql = "SELECT	*
			FROM	wcf".WCF_N."_user_option_category
			WHERE	categoryName = ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute([$categoryName]);
		$row = $statement->fetchArray();
		if ($row === false) return null;
		
		return new UserOptionCategory(null, $row);
	}
}
